<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Collection;

use Erlage\Photogram\Data\Models\AbstractModel;
use Erlage\Photogram\Data\Tables\Collection\CollectionTable;

final class CollectionModel extends AbstractModel implements InterfaceCollectionGetter
{
    /**
     * getter interface
     */
    use TraitCollectionGetters;

    public function getTableClassName(): string
    {
        return CollectionTable::erlClass();
    }

    /*
    |--------------------------------------------------------------------------
    | override the delete logic
    |--------------------------------------------------------------------------
    */

    public function delete(): bool
    {
        CollectionModelHelper::deleteDependencies($this);

        return parent::delete();
    }
}
